function v = wml(x,y,c,vinit,lambda)
% v = wml(x,y,c,vinit,lambda)
%
% x - N-by-D matrix of input samples \in {-inf,inf}
% y - N-by-1 vector of binary labels \in {0,1}
% c - N-by-1 vector of costs  \in {0,inf}
% vinit - (D+1)-by-1 initial guess of classifier \in {-inf,inf} (optional)
% lambda - L2 regularization parameter \in {0,inf} (optional)
%
% v - v(1:D) normal to separating hyperplane. v(D+1) threshold
%
% Lucas C. Parra, parra@ccny.cuny.edu, March 19th, 2004
% Jacek Dmochowski, jdmochowski@ccny.cuny.edu, May 27th, 2010 -- add
% example-dependent costs
[N,D]=size(x);
if isempty(vinit), v = zeros(D,1); vth=0;else vth=vinit(D+1);v=vinit(1:D); end;
if nargin<6; lambda=0; end;
s = std(x); x = x./repmat(s,[N 1]);
x = [x ones(N,1)];
v = [v; vth];
count=0;
lambda = [0.5*lambda*ones(1,D) 0]';
while 1
    vold=v;
    mu = bernoull(1,x*v);   % recompute weights
    w = mu.*(1-mu);
    w = w.*c; % add weighting to reflect costs
    e = (y - mu).*c;
    grad = x'*e - lambda .* v;
    inc = inv(x'*(repmat(w,1,D+1).*x)+diag(lambda)*eye(D+1)) * grad;
    if norm(inc)>=1000,
        warning('Data may be perfectly separable. Suggest to increase regularization constant lambda.');
        break;
    end;
    v = v + inc;  % update
    if norm(vold) & subspace(v,vold)<10^-10, break, end; % exit if converged
    count=count+1;
    if count>100,
        warning('Not converged after 100 iterations.');
        break;   % exit if its taking to long
    end;
end; % while loop
v(1:end-1) = v(1:end-1)./s';

function [p]=bernoull(x,eta);
% [p] = bernoull(x,eta)
p = exp(eta.*x - log(1+exp(eta)));








