function [vhat,fval] = train_sigrisk(x,y,c,v,lambda,options) 
% TRAIN_SIGRISK train the sigmoidal cost-sensitive classifier
%
% [VHAT,OUTPUT,FVAL] = TRAIN_SIGRISK(X,Y,C,V,LAMBDA,OPTIONS) 
% Jacek Dmochowski
costfun = @(theta)sigrisk(theta,x,y,c,lambda);
D = min(size(x,1),size(x,2));
% set default options for matlab's fminunc
if nargin<6
    options = optimset('GradObj','on','Hessian','off','LargeScale','off','Display','off','DerivativeCheck','off','TolFun',1e-10,'TolX',1e-10);
end
if isempty(v),v=zeros(D+1,1); end
try
    [vhat,fval] = fminunc(costfun,v,options);
catch
     vhat=zeros(D+1,1);
     fval=inf;
end