function [res, grad] = sigrisk(theta,x,y,c,lambda)
% [RES, GRAD] = SIGRISK(THETA,X,Y,C,LAMBDA)
% 
% compute the sigmoidal risk of a given classifier on a set of labeled
% examples
%
% Jacek Dmochowski
[N,D] = size(x); if D>N, x = x'; [N,D] = size(x); end
X = [ones(N,1) , x];
y = y(:);
Xtheta = X*theta;
z = 2*y-1;  % transform {0,1}-->{-1,1}
res  = sum( ( 1./(1+exp(z.*Xtheta))) .*c );
reg = lambda*theta(2:end)'*theta(2:end);
res =  res+reg;
p = 1./(1+exp(z.*Xtheta));
grad =  -X.'* ((z.*c).*(p.*(1-p))); 
grad = grad + [0; 2*lambda*theta(2:end)];
