function v = multrest_train_sigrisk(x,y,c,sigma,lambda) 
% MULTREST_TRAIN_SIGRISK
%
% train sigmoidal cost-sensitive classifier with multiple restarts
% V = MULTREST_TRAIN_SIGRISK(X,Y,C,SIGMA,LAMBDA)
%
% Jacek Dmochowski
D = min(size(x,1),size(x,2));
output.iterations=-inf;
Nrest=100;
rsk=zeros(Nrest,1);
v=zeros(D+1,Nrest);
for n = 1:Nrest 
    [v(:,n) fval] = train_sigrisk(x,y,c,sigma*randn(D+1,1),lambda);     
    rsk(n)=fval;    
end
[a,b]=min(rsk);
v=v(:,b);