% 10/21/10
%
% This script demonstrates the usage of:
    % (1) logist() -- maximum likelihood with a linear classifier
    % (2) wml() -- weighted maximum likelihood with a linear classifier
    % (3) multrest_train_sigrisk() -- minimum sigmoidal risk with a linear
    % classifier
% on a very simple example.
%
% any questions should be directed to: Jacek Dmochowski
% (jdmochowski@ccny.cuny.edu)
% (c) Lucas C. Parra and J. P. Dmochowski

clear all; close all; clc
% generate some data
N=1000; % number of samples
D=2; % dimensionality
x=randn(N,D); % data
y=randint(N,1); % labels
indx=find(y==1); % positive labels
x(indx,:)=x(indx,:)+repmat([2 2],length(indx),1); % add separation
cp=1; % cost of misclassifying positive examples
cn=0.5; % cost of misclassifying negative examples
c=cn*ones(N,1); % initialize cost vector with c(-)
c(indx)=cp; % c(+)
lambda=eps; % L2 hyperparameter

% thresholded maximum likelihood
vml = logist(x,y,zeros(D+1,1),0,lambda); % train classifier
vml(end)=vml(end)-log(cn/cp); % adjust threshold
decml=( x*vml(1:D)+vml(D+1) ) > 0; % classifier decisions
costml=sum( xor(decml,y).*c ) ; % training cost
fprintf('Training cost of thresholded ML = %g  \n',costml); % display performance

% weighted maximum likelihood
vwml = wml(x,y,c,zeros(D+1,1),lambda);
decwml=( x*vwml(1:D)+vwml(D+1) ) > 0;
costwml=sum( xor(decwml,y).*c ) ; 
fprintf('Training cost of weighted ML = %g  \n',costwml);

% sigmoidal risk
vsig = multrest_train_sigrisk(x,y,c,1,lambda);
decsig=( x*vsig(2:end)+vsig(1) ) > 0;
costsig=sum( xor(decsig,y).*c ) ; 
fprintf('Training cost of minimum sigmoidal risk = %g  \n',costsig);